#include "Jukebox.h"



Jukebox::Jukebox()
{
}


Jukebox::~Jukebox()
{
}

bool Jukebox::loadMTL(char* modelFilename, char* mtlFilename, int renderingShape)
{
	return Model::loadMTL(modelFilename, mtlFilename, renderingShape);
}

void Jukebox::SetLights(PointLight* one, PointLight* two)
{
	_PointOne = one;
	_PointTwo = two;
}

void Jukebox::render(Vector3 position)
{
	//Clear the shadow matrix
	std::fill(std::begin(shadowMatrix), std::end(shadowMatrix), 0.0f);

	//Generate shadow matrix for lights that are on
	if (_PointOne->GetIsOn())
	{
		Shadow::generateShadowMatrix(shadowMatrix, &_PointOne->GetPosition()[0], floorVerts);
	}

	if (_PointTwo->GetIsOn())
	{
		Shadow::generateShadowMatrix(shadowMatrix, &_PointTwo->GetPosition()[0], floorVerts);
	}

	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);

	//Shadow of model
	glPushMatrix();
		glColor3f(0.1f, 0.1f, 0.1f); // Shadow's colour
		glPushMatrix();
			glMultMatrixf((GLfloat *)shadowMatrix);
			glTranslatef(position.x, position.y, position.z);
			Model::render();
		glPopMatrix();
	glPopMatrix();

	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);

	//Actual model
	glPushMatrix();
		glTranslatef(position.x, position.y, position.z);
		Model::render();
	glPopMatrix();
}